rem start here 
@echo off 
rem --------------------------------------------- 
rem -------- How to use this script ------------ 
rem ---------------------------------------------


rem --Change the "KATANA Specific" section to reflect your install path, custom tools, etc-- 
rem --Delete the settings for the renderers that you do not have installed or do not want to use at the same time.--


rem --"KATANA_RESOURCES" is the environment variable that drives what gets loaded at startup for KATANA. This is how you load tools and plug-ins-- 
rem --"DEFAULT_RENDERER" is the environment variable that drives which renderer plug-in is expected by default in a "RenderSettings" node.-- 
rem --Different renderer plug-ins have a range of needs for the PATH environment variable-- 
rem --Some renderer plug-ins are still in beta and their environment variable requirements may change.--


rem -------------------------------------- 
rem -------- KATANA Specific ------------ 
rem -------------------------------------- 
rem --Define the install location for KATANA and add binaries to the PATH-- 
set "KATANA_ROOT=C:\Program Files\Katana2.5v4" 
set "PATH=%PATH%;%KATANA_ROOT%\bin"


rem --Make the example projects like the PyMock asset plugins available in KATANA 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;%KATANA_ROOT%\plugins\Resources\Examples"


rem --This line is a simple example of how custom shelf scripts can be sourced-- 
rem http://help.thefoundry.co.uk/katana/current/#tg/shelf_item_scripts/shelf_item_scripts.html 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;C:\Users\jordan\Dropbox\katana_shelves" 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;C:\Users\Jordan\Dropbox\katana_tools"

rem -This is how you set the default renderer when more than one are used at once (arnold, prman, vray, dl) 
rem - Change this to match the renderer you want to use by default. 
set "DEFAULT_RENDERER=arnold" 
rem !!--------------------------------!!

 

 

rem !!!!!!!!!!!!! Delete the tools you do not use from the section below !!!!!!!!!!!!!

 


rem ---------------------------------------- 
rem -------- 3Delight Specific ------------ 
rem ---------------------------------------- 
rem --This is the location of where the main 3Delight package is installed-- 
set "DELIGHT=C:\Program Files\3Delight" 
rem --This is the location of the 3Delight for KATANA plugin-- 
set "DLFK_INSTALL_PATH=C:\Program Files\3Delight_for_Katana.09.windows"


rem --These make sure that all the shaders, and tools can be found by the plugin/renderer-- 
set "DL_DISPLAYS_PATH=C:\Program Files\3Delight\displays" 
set "DL_SHADERS_PATH=C:\Program Files\3Delight\shaders" 
set "PATH=%PATH%;C:\Program Files\3Delight\bin"


rem --This is the location of the 3Delight for KATANA plug-in-- 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;%DLFK_INSTALL_PATH%" 
rem !!--------------------------------!!

 

 

rem ------------------------------------------ 
rem -------- Multiverse Specific ------------ 
rem ------------------------------------------ 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;C:\Program Files\MFK-0.1" 
rem --------------------------------

 

 


rem -------------------------------------- 
rem -------- Arnold Specific ------------ 
rem -------------------------------------- 
rem --Where you have installed the KtoA plug-in-- 
set "ARNOLD_INSTALL_PATH=C:\Program Files\KtoA-1.1-kat2.5-windows"


rem --Without these three KtoA will not function-- 
set "ARNOLD_PLUGIN_PATH=%ARNOLD_INSTALL_PATH%\Plugins" 
set "ARNOLD_VERSION=4.2.14.2" 
set "PATH=%PATH%;%ARNOLD_INSTALL_PATH%\bin"


rem --To install the AlShaders 
rem --http://www.anderslanglands.com/alshaders/index.html-- 
rem --Copy the Args folder itself to the bin folder of AlShaders folder-- 
rem --Set this line below to include the AlShaders into the Arnold shader path 
set "ALSHADER_PATH=C:\Program Files\alShaders-win-1.0.0rc17-ai4.2.12.2\bin" 
set "ARNOLD_PLUGIN_PATH=%ARNOLD_PLUGIN_PATH%;%ALSHADER_PATH%"


rem --This is how to load the KtoA plug-in-- 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;%ARNOLD_INSTALL_PATH%" 
rem !!--------------------------------!!

 


rem -------------------------------------------- 
rem -------- RenderMan 20 Specific ------------ 
rem -------------------------------------------- 
rem --This is the location of the PRman plugin for KATANA-- 
set "RFKTREE=C:\Program Files\Pixar\RenderManForKatana-20.9-katana2.5" 
rem --This is the location of the RenderMan Pro Server installation-- 
set "RMANTREE=C:\Program Files\Pixar\RenderManProServer-20.10"


rem --These make sure that the programs can be found, shaders loaded, and all components used-- 
rem --This is different for PRman 21 so do not try to use the same for both versions once there is a PRman 21 RfK for Windows-- 
set "PATH=%PATH%;%RMANTREE%\lib;%RMANTREE%\bin" 
set "RISDIR=%RMANTREE%\lib\RIS" 
set "RMAN_RIXPLUGINPATH=%RISDIR%\bxdf;%RISDIR%\pattern;%RISDIR%\integrator;%RISDIR%\projection;%RISDIR%\light"
set "RMAN_SHADERPATH=%RMAN_SHADERPATH%;%RFKTREE%\Resources\PRMan20\Shaders;%RMANTREE%\lib\shaders;%RMANTREE%\lib\rsl\shaders"


rem --This is what is required to load the RfK plugin-- 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;%RFKTREE%\Resources\PRMan20" 
rem !!--------------------------------!!

 


rem -------------------------------------------- 
rem -------- RenderMan 21 Specific ------------ 
rem -------------------------------------------- 
rem --This is the location of the PRman plugin for KATANA in this case the one The Foundry compiled for testing-- 
set "RFKTREE=C:\Program Files\Pixar\RenderManForKatana-21.1-katana2.5\plugins" 
rem --This is the location of the RenderMan Pro Server installation-- 
set "RMANTREE=C:\Program Files\Pixar\RenderManProServer-21.1"


rem --These make sure that the programs can be found, shaders loaded, and all components used-- 
rem --This is different for PRman 21 so do not try to use the same for both versions once there is a PRman 21 RfK for Windows-- 
set "PATH=%PATH%;%RMANTREE%\lib;%RMANTREE%\bin"


rem --This is what is required to load the RfK plugin-- 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;%RFKTREE%\Resources\PRMan21" 
rem !!--------------------------------!!

 


rem ------------------------------------- 
rem -------- V-Ray Specific ------------ 
rem ------------------------------------- 
rem --Location of the V-Ray for KATANA install directory.-- 
rem --Not the syntax for Program Files as at the time of testing the plugin did not like spaces in directory names. This could be fixed-- 
set "VRAY_INSTALL_PATH=C:\Progra~1\vray_adv_30501_katana_2_5_x64"


rem --Specific location to call out the plug-in to itsef-- 
set "VRAY_FOR_KATANA_PLUGINS_x64=%VRAY_INSTALL_PATH%\vrayplugins"


rem --This is required to access the tools that parse all the shaders-- 
set "PATH=%PATH%;%VRAY_INSTALL_PATH%\RenderBin"


rem --This is how the V-Ray plugin gets loaded-- 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;%VRAY_INSTALL_PATH%" 
rem !!--------------------------------!!

 



rem -------- Deadline Specific ------------ 
set "KATANA_RESOURCES=%KATANA_RESOURCES%;C:\Users\Jordan\AppData\Local\Thinkbox\Deadline8\submitters\KatanaSubmitter"
rem --------------------------------

 


rem !!!!!!!!!!!!! Stop deleting parts of the script. Leave the rest of this script alone !!!!!!!!!!!!!

 


rem -------- Start KATANA ------------ 
"%KATANA_ROOT%\bin\katanaBin.exe"